package usb4all;

import java.util.Arrays;

public class HandlerPacket {

    //	datos del paquete
	public static final int OVER_HEAD = 3;
	private static final int PACKET_LENGTH = 64;
	private static final int PAYLOAD_LENGTH = PACKET_LENGTH - OVER_HEAD; 
	
//	tipo de operacion
	public static final int SEND 	 = 0x00;
	public static final int RECEIVE = 0x01;
	public static final int CONFIG  = 0x02;
	public static final int OPEN    = 0x03;
	public static final int CLOSE   = 0x04;
	public static final int SEND1   = 0x05;
	public static final int SEND2   = 0x06;
	public static final int SEND3   = 0x07;
	
	byte[] packet;
	int handler;
	int op_type;
	int packet_len;
	int payload_len;
	int reserved;
	byte[] payload;
	
	public boolean parsePacket(byte[] pack){
		
		if (pack.length<=OVER_HEAD){
			System.out.println("Error en parsePacket: Packet mas chico que overhead!");
			return false;
		}
		else {
			packet=pack;
			payload = new byte[packet.length-OVER_HEAD];
			for (int i=0 ; i<packet.length-OVER_HEAD ; i++){
				payload[i]=packet[i+OVER_HEAD];
			}
			//saco campos header y packet
			handler = (pack[0] & 0xF8)>>3;
			op_type = (pack[0] & 0x07);
			packet_len = pack[1];
			reserved = pack[2];
		}
		return true;
	}

	public boolean parsePayload(int handler,int op_type,int reserved,byte[] payl){
		
		if (payl.length>PAYLOAD_LENGTH){
			System.out.println("Error en parsePayload: Payload mas grande que PAYLOAD_LENGTH");
			return false;
		}
		else {
			payload=payl;
			packet = new byte[payl.length+OVER_HEAD];
			for (int i=0 ; i<payl.length ; i++){
				packet[i+OVER_HEAD]= payl[i];
			}
			//saco campos header y packet
			packet[1] = (byte)packet.length;
			packet[2] = (byte)reserved;
			packet[0] = (byte)((handler << 3) + (op_type % 8));
		}
		return true;
	}
	
	public void printPacket(){
		byte[] c=packet;
		//System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		System.out.println();
	}
	
	public void printPayload(){
		byte[] c=payload;
		//System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		System.out.println();
	}


	public int getPacket_len() {
		return packet_len;
	}






	public void setPacket_len(int packet_len) {
		this.packet_len = packet_len;
	}






	public int getPayload_len() {
		return payload_len;
	}






	public void setPayload_len(int payload_len) {
		this.payload_len = payload_len;
	}






	public int getReserved() {
		return reserved;
	}



	public void setReserved(int reserved) {
		this.reserved = reserved;
	}



	public byte[] getPayload() {
		return payload;
	}



	public void setPayload(byte[] payload) {
		this.payload = payload;
	}

	public HandlerPacket(){}

	public HandlerPacket(int handler, int op_type) {
		super();
		// TODO Auto-generated constructor stub
		this.handler = handler;
		this.op_type = op_type;
		
	}



	public int getHandler() {
		return handler;
	}

	public void setHandler(int handler) {
		this.handler = handler;
	}

	public int getOp_type() {
		return op_type;
	}

	public void setOp_type(int op_type) {
		this.op_type = op_type;
	}

	public byte[] getPacket() {
		return packet;
	}

	public void setPacket(byte[] packet) {
		this.packet = packet;
	}
	
	
	
}
